﻿$(function ($) {

    // Date format function
    $.fn.getFormattedDateValue = function(sourceFormat, destinationFormat) {
        if (!this.length) {
            return '';
        }

        // Require a value
        var value = $(this).val();
        if (!value) {
            return '';
        }

        // Format and return
        var dateValue = $.fn.datepicker.DPGlobal.parseDate(value, sourceFormat, 'en');
        return $.fn.datepicker.DPGlobal.formatDate(dateValue, destinationFormat, 'en');
    };

    // Show a progress bar with an optional description
    // Supports only single element selected
    $.fn.progressBar = function (opts) {
        // If nothing is selected, return nothing; can't chain anyway
        if (!this.length) {
            return;
        }

        // Get data for current element
        var data = this.data();

        // Remove any existing
        if (data.ajaxReplaceProgressBar) {
            data.ajaxReplaceProgressBar.remove();
            delete data.ajaxReplaceProgressBar;
        }

        // If explicitly 'false' specified then don't re-add after removing
        if (opts === false) {
            return;
        }

        // Merge provided options with defaults
        var options = $.extend($.fn.progressBar.defaults, opts);

        // Generate HTML
        var barHtml = '<div class="progressbar" style="width:' + options.width + ';margin:0 auto;text-align:center;">';
        if (options.description) {
            barHtml += '<p><b>' + options.description + '</b></p>';
        }
        barHtml += '<div class="progress progress-striped active">'
            + ' <div class="progress-bar" role="progressbar" aria-valuenow="' + options.percentage + '"'
            + ' aria-valuemin="0" aria-valuemax="' + options.percentage + '" style="width: ' + options.percentage + '%">'
            + '<span class="sr-only">' + (options.description || (options.percentage + '%')) + '</span>' +
            + '</div></div></div>';

        // Store and add
        data.ajaxReplaceProgressBar = $(barHtml);
        this.prepend(data.ajaxReplaceProgressBar);
    };
    $.fn.progressBar.defaults = {
        percentage: '100',
        description: '',
        width: '100%'
    };

    // Post/Ajax replace functions
    // Adapted from: http://stackoverflow.com/a/17397198/364
    $.extend($.fn, {
        ajaxReplace: function (url, settings) {

            // If nothing is selected, return nothing; can't chain anyway
            if (!this.length) {
                return;
            }

            // Todo: Support for replacing multiple elements.

            var target = $(this[0]);

            $.ajax({
                url: url,
                beforeSend: function (jqXHR, ajaxSettings) {
                    if (settings && settings.startAnimation) {
                        settings.startAnimation(target);
                    } else {
                        startAnimation(target);
                    }

                    if (settings && settings.beforeSend) {
                        settings.beforeSend(target, jqXHR, ajaxSettings);
                    }
                },
                success: function (result, textStatus, jqXHR) {
                    $(target).html(result);

                    if (settings && settings.success) {
                        settings.success(target, result, textStatus, jqXHR);
                    }
                },
                complete: function (jqXHR, textStatus) {
                    if (settings && settings.stopAnimation) {
                        settings.stopAnimation(target);
                    } else {
                        stopAnimation(target);
                    }

                    if (settings && settings.complete) {
                        settings.complete(target, jqXHR, textStatus);
                    }
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    var ajaxContext = this;
                    var status = textStatus.charAt(0).toUpperCase() + textStatus.slice(1);
                    var error = errorThrown || '(None)';

                    // Known and handled 'exception' cases
                    if (jqXHR.status == 422) {
                        ajaxContext.success(jqXHR.responseText, textStatus, jqXHR); // Call success handler
                        return;
                    }

                    $(target).html('<div class="alert alert-danger alert-dismissable">'
                          + '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>'
                          + '<span class="glyphicon glyphicon-warning-sign"></span>'
                          + ' An error was encountered (Status: ' + status + ', Error Message: ' + error + ')'
                          + '</div>');

                    if (settings && settings.error) {
                        settings.error(target, jqXHR, textStatus, errorThrown);
                    }
                }
            });
        },

        postReplace: function (target, settings) {

            // If nothing is selected, return nothing; can't chain anyway
            if (!this.length) {
                return;
            }

            // Supports single form, single target.
            var form = $(this[0]);

            $.ajax({
                url: form.attr('action'),
                data: form.serialize(),
                type: 'POST',
                beforeSend: function(jqXHR) {
                    if (settings && settings.startAnimation) {
                        settings.startAnimation(target);
                    } else {
                        startAnimation(target);
                    }

                    if (settings && settings.beforeSend) {
                        settings.beforeSend(target, jqXHR);
                    }
                },
                success: function(result, textStatus, jqXHR) {
                    $(target).html(result);

                    if (settings && settings.success) {
                        settings.success(target, result, textStatus, jqXHR);
                    }
                },
                complete: function (jqXHR, textStatus) {
                    if (settings && settings.stopAnimation) {
                        settings.stopAnimation(target);
                    } else {
                        stopAnimation(target);
                    }

                    if (settings && settings.complete) {
                        settings.complete(target, jqXHR, textStatus);
                    }
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    var ajaxContext = this;
                    var status = textStatus.charAt(0).toUpperCase() + textStatus.slice(1);
                    var error = errorThrown ? errorThrown : '(None)';

                    // Known and handled 'exception' cases
                    if (jqXHR.status == 422) {
                        ajaxContext.success(jqXHR.responseText, textStatus, jqXHR); // Call success handler
                        return;
                    }

                    $(target).html('<div class="alert alert-danger alert-dismissable">'
                          + '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>'
                          + '<span class="glyphicon glyphicon-warning-sign"></span>'
                          + ' An error was encountered (Status: ' + status + ', Error Message: ' + error + ')'
                          + '</div>');

                    if (settings && settings.error) {
                        settings.error(target, jqXHR, textStatus, errorThrown);
                    }
                }
            });
        }
    });
        
    function startAnimation(target) {
        //..add a loading image on top of the target  
        $(target).spin();
    }

    function stopAnimation(target) {
        // remove the animation gif or stop the spinning, etc.
        $(target).spin(false);
    }
}(jQuery));

    